%   Copyright  2020 University of Extremadura (UEx)
%
% loadDeployment
%  Input:
%   set: Current deployment information
%
%  Output:
%   data: Structure all the data of the deployment
%   
% -----------------------------------------

function [data, bcCoords] = loadSet(set)
    
    data = struct;
    % RSSI data
    data.rss = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_rss.csv'));
    % RP coordinates
    data.coords = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_cdr.csv'));
    % Timestamp
    data.time = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_tms.csv'));
    % Measurement code
    data.ids = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_code.csv'));
    % Tag Id
    data.zoneId = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_zoneId.csv'));
    % idxTrain
    data.idxTrain = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_idxRadioMap.csv'));
    % idxTest
    data.idxTest = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_idxEvaluation.csv'));
    % Beacons coordinates
    data.bcCoords = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_beacons_cdr.csv'));
    
end

